import './bootstrap';

import Alpine from 'alpinejs';

window.Alpine = Alpine;

Alpine.start();

// Refresh CSRF token every 10 minutes to prevent 419 errors
setInterval(function() {
    fetch('/refresh-csrf')
        .then(response => response.json())
        .then(data => {
            if (data.token) {
                document.querySelectorAll('input[name="_token"]').forEach(input => {
                    input.value = data.token;
                });
                document.querySelector('meta[name="csrf-token"]')?.setAttribute('content', data.token);
            }
        })
        .catch(error => console.log('CSRF token refresh failed'));
}, 600000); // 10 minutes
