<?php if (isset($component)) { $__componentOriginal951024bfcf58033c82ac11d797616473 = $component; } ?>
<?php if (isset($attributes)) { $__attributesOriginal951024bfcf58033c82ac11d797616473 = $attributes; } ?>
<?php $component = App\View\Components\UserLayout::resolve([] + (isset($attributes) && $attributes instanceof Illuminate\View\ComponentAttributeBag ? $attributes->all() : [])); ?>
<?php $component->withName('user-layout'); ?>
<?php if ($component->shouldRender()): ?>
<?php $__env->startComponent($component->resolveView(), $component->data()); ?>
<?php if (isset($attributes) && $attributes instanceof Illuminate\View\ComponentAttributeBag): ?>
<?php $attributes = $attributes->except(\App\View\Components\UserLayout::ignoredParameterNames()); ?>
<?php endif; ?>
<?php $component->withAttributes([]); ?>
     <?php $__env->slot('header', null, []); ?> 
        Stock Marketplace
     <?php $__env->endSlot(); ?>

    <div class="max-w-7xl mx-auto">
        <!-- Enhanced Header -->
        <div class="bg-gradient-to-br from-blue-600 via-blue-700 to-blue-800 dark:from-blue-700 dark:via-blue-800 dark:to-blue-900 rounded-2xl p-6 mb-6 text-white relative overflow-hidden">
            <!-- Background Pattern -->
            <div class="absolute inset-0 opacity-10">
                <div class="absolute top-0 right-0 w-48 h-48 bg-white rounded-full -translate-y-24 translate-x-24"></div>
                <div class="absolute bottom-0 left-0 w-24 h-24 bg-white rounded-full translate-y-12 -translate-x-12"></div>
            </div>
            
            <div class="relative z-10">
                <div class="flex flex-col lg:flex-row lg:items-center lg:justify-between">
                    <div class="mb-4 lg:mb-0 lg:flex-1">
                        <div class="flex items-center mb-1">
                            <h1 class="text-xl font-light">Stock Marketplace</h1>
                            <div class="ml-3 real-time-indicator">
                                <span class="inline-flex items-center px-2 py-0.5 rounded-full text-xs font-medium bg-green-900 text-green-300">
                                    <i data-lucide="radio" class="w-3 h-3 mr-1"></i>
                                    Live
                                </span>
                            </div>
                        </div>
                        <p class="text-blue-100 dark:text-blue-200 text-sm">Discover and trade stocks from leading companies</p>
                        <p class="text-xs text-gray-400 mt-1">Last updated: <span data-last-updated><?php echo e(now()->format('H:i:s')); ?></span></p>
                    </div>
                    
                    <!-- Enhanced Stats Card -->
                    <div class="bg-white bg-opacity-15 backdrop-blur-xl rounded-xl p-4 border border-white border-opacity-20 shadow-xl lg:w-80">
                        <div class="flex items-center justify-between mb-3">
                            <div>
                                <p class="text-xs text-blue-100 dark:text-blue-200 mb-1">Active Stocks</p>
                                <p class="text-lg font-light"><?php echo e($stocks->total()); ?></p>
                            </div>
                            <div class="w-10 h-10 flex items-center justify-center">
                                <i data-lucide="bar-chart-3" class="w-5 h-5 text-white"></i>
                            </div>
                        </div>
                        <div class="flex space-x-4 text-xs">
                            <div class="flex-1 text-center">
                                <p class="text-blue-100 dark:text-blue-200">Gainers</p>
                                <p class="text-white font-medium"><?php echo e($gainers->count()); ?></p>
                            </div>
                            <div class="flex-1 text-center">
                                <p class="text-blue-100 dark:text-blue-200">Losers</p>
                                <p class="text-white font-medium"><?php echo e($losers->count()); ?></p>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>

        <!-- Market Overview -->
        <div class="grid grid-cols-1 md:grid-cols-3 gap-4 mb-6" data-market-section="overview">
            <!-- Top Gainers -->
            <a href="<?php echo e(route('stocks.gainers')); ?>" class="block bg-white dark:bg-blue-700 rounded-xl p-4 shadow-sm border border-gray-100 hover:shadow-md hover:border-green-200 dark:hover:border-green-600 transition-all duration-200 group cursor-pointer" data-market-section="gainers">
                <div class="flex items-center justify-between mb-3">
                    <div>
                        <p class="text-xs text-gray-500 dark:text-blue-100 mb-1">Top Gainers</p>
                        <p class="text-lg font-light text-green-600 stock-price" data-stock-symbol="<?php echo e($gainers->first() ? $gainers->first()->symbol : ''); ?>">+<?php echo e($gainers->first() ? number_format($gainers->first()->change_percentage, 2) : '0.00'); ?>%</p>
                        <p class="text-xs text-gray-400 mt-1">Click to view all</p>
                    </div>
                    <div class="w-8 h-8 flex items-center justify-center">
                        <i data-lucide="trending-up" class="w-4 h-4 text-green-600 group-hover:scale-110 transition-transform duration-200"></i>
                    </div>
                </div>
            </a>

            <!-- Top Losers -->
            <a href="<?php echo e(route('stocks.losers')); ?>" class="block bg-white dark:bg-blue-700 rounded-xl p-4 shadow-sm border border-gray-100 hover:shadow-md hover:border-red-200 dark:hover:border-red-600 transition-all duration-200 group cursor-pointer" data-market-section="losers">
                <div class="flex items-center justify-between mb-3">
                    <div>
                        <p class="text-xs text-gray-500 dark:text-blue-100 mb-1">Top Losers</p>
                        <p class="text-lg font-light text-red-600 stock-price" data-stock-symbol="<?php echo e($losers->first() ? $losers->first()->symbol : ''); ?>"><?php echo e($losers->first() ? number_format($losers->first()->change_percentage, 2) : '0.00'); ?>%</p>
                        <p class="text-xs text-gray-400 mt-1">Click to view all</p>
                    </div>
                    <div class="w-8 h-8 flex items-center justify-center">
                        <i data-lucide="trending-down" class="w-4 h-4 text-red-600 group-hover:scale-110 transition-transform duration-200"></i>
                    </div>
                </div>
            </a>

            <!-- Most Active -->
            <a href="<?php echo e(route('stocks.most-active')); ?>" class="block bg-white dark:bg-blue-700 rounded-xl p-4 shadow-sm border border-gray-100 hover:shadow-md hover:border-blue-200 dark:hover:border-blue-500 transition-all duration-200 group cursor-pointer" data-market-section="most-active">
                <div class="flex items-center justify-between mb-3">
                    <div>
                        <p class="text-xs text-gray-500 dark:text-blue-100 mb-1">Most Active</p>
                        <p class="text-lg font-light text-black stock-volume" data-stock-symbol="<?php echo e($mostActive->first() ? $mostActive->first()->symbol : ''); ?>"><?php echo e($mostActive->first() ? $mostActive->first()->formatted_volume : '0'); ?></p>
                        <p class="text-xs text-gray-400 mt-1">Click to view all</p>
                    </div>
                    <div class="w-8 h-8 flex items-center justify-center">
                        <i data-lucide="activity" class="w-4 h-4 text-blue-600 group-hover:scale-110 transition-transform duration-200"></i>
                    </div>
                </div>
            </a>
        </div>

        <!-- Search and Filters -->
        <div class="bg-white dark:bg-blue-700 rounded-xl p-4 shadow-sm border border-gray-100 mb-6">
            <form method="GET" class="grid grid-cols-1 md:grid-cols-5 gap-4">
                <!-- Search -->
                <div>
                    <label for="search" class="block text-xs font-medium text-gray-700 mb-1">Search</label>
                    <input type="text" id="search" name="search" value="<?php echo e(request('search')); ?>" placeholder="Symbol or company name" class="w-full px-3 py-2 border border-gray-300 dark:border-blue-600 dark:bg-blue-600 dark:text-white rounded-lg focus:ring-2 focus:ring-black focus:border-transparent transition-colors duration-200">
                </div>

                <!-- Sector Filter -->
                <div>
                    <label for="sector" class="block text-xs font-medium text-gray-700 mb-1">Sector</label>
                    <select id="sector" name="sector" class="w-full px-3 py-2 border border-gray-300 dark:border-blue-600 dark:bg-blue-600 dark:text-white rounded-lg focus:ring-2 focus:ring-black focus:border-transparent transition-colors duration-200">
                        <option value="">All Sectors</option>
                        <?php $__currentLoopData = $sectors; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $sector): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                            <option value="<?php echo e($sector); ?>" <?php echo e(request('sector') == $sector ? 'selected' : ''); ?>><?php echo e($sector); ?></option>
                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                    </select>
                </div>

                <!-- Industry Filter -->
                <div>
                    <label for="industry" class="block text-xs font-medium text-gray-700 mb-1">Industry</label>
                    <select id="industry" name="industry" class="w-full px-3 py-2 border border-gray-300 dark:border-blue-600 dark:bg-blue-600 dark:text-white rounded-lg focus:ring-2 focus:ring-black focus:border-transparent transition-colors duration-200">
                        <option value="">All Industries</option>
                        <?php $__currentLoopData = $industries; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $industry): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                            <option value="<?php echo e($industry); ?>" <?php echo e(request('industry') == $industry ? 'selected' : ''); ?>><?php echo e($industry); ?></option>
                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                    </select>
                </div>

                <!-- Sort -->
                <div>
                    <label for="sort" class="block text-xs font-medium text-gray-700 mb-1">Sort By</label>
                    <select id="sort" name="sort" class="w-full px-3 py-2 border border-gray-300 dark:border-blue-600 dark:bg-blue-600 dark:text-white rounded-lg focus:ring-2 focus:ring-black focus:border-transparent transition-colors duration-200">
                        <option value="symbol" <?php echo e(request('sort') == 'symbol' ? 'selected' : ''); ?>>Symbol</option>
                        <option value="price" <?php echo e(request('sort') == 'price' ? 'selected' : ''); ?>>Price</option>
                        <option value="change" <?php echo e(request('sort') == 'change' ? 'selected' : ''); ?>>Change</option>
                        <option value="volume" <?php echo e(request('sort') == 'volume' ? 'selected' : ''); ?>>Volume</option>
                        <option value="market_cap" <?php echo e(request('sort') == 'market_cap' ? 'selected' : ''); ?>>Market Cap</option>
                    </select>
                </div>

                <!-- Actions -->
                <div class="flex items-end space-x-2">
                    <button type="submit" class="px-4 py-2 bg-black dark:bg-white text-white dark:text-blue-900 text-xs font-medium rounded-lg hover:bg-gray-800 dark:hover:bg-blue-50 transition-colors duration-200">
                        <i data-lucide="search" class="w-3 h-3 mr-1"></i>
                        Search
                    </button>
                    <a href="<?php echo e(route('stocks.index')); ?>" class="px-4 py-2 border border-gray-300 dark:border-blue-600 text-black dark:text-white dark:bg-blue-700 text-xs font-medium rounded-lg hover:bg-gray-50 dark:hover:bg-blue-600 transition-colors duration-200">
                        <i data-lucide="refresh-cw" class="w-3 h-3 mr-1"></i>
                        Clear
                    </a>
                </div>
            </form>
        </div>

        <!-- Featured Stocks -->
        <?php if($featuredStocks->count() > 0): ?>
        <div class="bg-white dark:bg-blue-700 rounded-xl p-6 shadow-sm border border-gray-100 mb-6">
            <div class="flex items-center justify-between mb-4">
                <div>
                    <h3 class="text-lg font-light text-black dark:text-white mb-1">Featured Stocks</h3>
                    <p class="text-xs text-gray-500 dark:text-blue-200">Handpicked stocks for your portfolio</p>
                </div>
            </div>
            
            <div class="grid grid-cols-1 md:grid-cols-2 lg:grid-cols-3 gap-4" data-market-section="featured">
                <?php $__currentLoopData = $featuredStocks; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $stock): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                <div class="bg-gray-50 dark:bg-blue-600 rounded-lg p-4 hover:bg-gray-100 dark:hover:bg-blue-500 transition-all duration-300" data-stock-index="<?php echo e($loop->index); ?>">
                    <div class="flex items-center justify-between mb-3">
                        <div>
                            <h4 class="text-sm font-medium text-black stock-symbol"><?php echo e($stock->symbol); ?></h4>
                            <p class="text-xs text-gray-500 stock-name"><?php echo e($stock->company_name); ?></p>
                        </div>
                        <div class="text-right">
                            <p class="text-sm font-medium text-black stock-price" data-stock-symbol="<?php echo e($stock->symbol); ?>" data-previous-price="<?php echo e($stock->current_price); ?>"><?php echo e($stock->formatted_current_price); ?></p>
                            <p class="text-xs <?php echo e($stock->change_color); ?> stock-change" data-stock-change="<?php echo e($stock->symbol); ?>">
                                <?php echo e($stock->formatted_change_amount); ?> (<?php echo e($stock->formatted_change_percentage); ?>)
                            </p>
                        </div>
                    </div>
                    <div class="flex items-center justify-between">
                        <span class="text-xs text-gray-500 dark:text-blue-200"><?php echo e($stock->sector); ?></span>
                        <a href="<?php echo e(route('stocks.show', $stock)); ?>" class="text-xs text-blue-600 hover:text-blue-800 transition-colors duration-200">
                            View Details
                        </a>
                    </div>
                </div>
                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
            </div>
        </div>
        <?php endif; ?>

        <!-- Stock List -->
        <div class="bg-white dark:bg-blue-700 rounded-xl shadow-sm border border-gray-100 overflow-hidden">
            <div class="px-6 py-4 border-b border-gray-100 dark:border-blue-600">
                <div class="flex items-center justify-between">
                    <div>
                        <h3 class="text-lg font-light text-black dark:text-white mb-1">All Stocks</h3>
                        <p class="text-xs text-gray-500 dark:text-blue-200"><?php echo e($stocks->total()); ?> stocks available</p>
                    </div>
                </div>
            </div>
            
            <?php if($stocks->count() > 0): ?>
                <div class="overflow-x-auto">
                    <table class="w-full">
                        <thead class="bg-gray-50">
                            <tr>
                                <th class="px-6 py-3 text-left text-xs font-medium text-gray-500 uppercase tracking-wider">Stock</th>
                                <th class="px-6 py-3 text-left text-xs font-medium text-gray-500 uppercase tracking-wider">Price</th>
                                <th class="px-6 py-3 text-left text-xs font-medium text-gray-500 uppercase tracking-wider">Change</th>
                                <th class="px-6 py-3 text-left text-xs font-medium text-gray-500 uppercase tracking-wider">Volume</th>
                                <th class="px-6 py-3 text-left text-xs font-medium text-gray-500 uppercase tracking-wider">Market Cap</th>
                                <th class="px-6 py-3 text-left text-xs font-medium text-gray-500 uppercase tracking-wider">Actions</th>
                            </tr>
                        </thead>
                        <tbody class="bg-white dark:bg-blue-700 divide-y divide-gray-100 dark:divide-blue-600">
                            <?php $__currentLoopData = $stocks; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $stock): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                            <tr class="hover:bg-gray-50 transition-colors duration-200 stock-row" data-stock-symbol="<?php echo e($stock->symbol); ?>">
                                <td class="px-6 py-4">
                                    <div class="flex items-center">
                                        <div class="flex-shrink-0 w-8 h-8 rounded-lg overflow-hidden">
                                            <?php if($stock->logo_url): ?>
                                                <img src="<?php echo e($stock->logo_url); ?>" alt="<?php echo e($stock->company_name); ?>" class="w-8 h-8 object-cover">
                                            <?php else: ?>
                                                <div class="w-8 h-8 bg-gray-100 dark:bg-blue-600 rounded-lg flex items-center justify-center">
                                                    <i data-lucide="bar-chart-3" class="w-4 h-4 text-gray-600 dark:text-blue-100"></i>
                                                </div>
                                            <?php endif; ?>
                                        </div>
                                        <div class="ml-3">
                                            <div class="text-sm font-medium text-black stock-symbol"><?php echo e($stock->symbol); ?></div>
                                            <div class="text-xs text-gray-500 stock-name"><?php echo e($stock->company_name); ?></div>
                                        </div>
                                    </div>
                                </td>
                                <td class="px-6 py-4">
                                    <div class="text-sm text-black stock-price" data-stock-symbol="<?php echo e($stock->symbol); ?>" data-previous-price="<?php echo e($stock->current_price); ?>"><?php echo e($stock->formatted_current_price); ?></div>
                                </td>
                                <td class="px-6 py-4">
                                    <div class="text-sm <?php echo e($stock->change_color); ?> stock-change" data-stock-change="<?php echo e($stock->symbol); ?>">
                                        <?php echo e($stock->formatted_change_amount); ?>

                                    </div>
                                    <div class="text-xs <?php echo e($stock->change_color); ?> stock-change" data-stock-change="<?php echo e($stock->symbol); ?>">
                                        <?php echo e($stock->formatted_change_percentage); ?>

                                    </div>
                                </td>
                                <td class="px-6 py-4">
                                    <div class="text-sm text-black stock-volume" data-stock-volume="<?php echo e($stock->symbol); ?>"><?php echo e($stock->formatted_volume); ?></div>
                                </td>
                                <td class="px-6 py-4">
                                    <div class="text-sm text-black"><?php echo e($stock->formatted_market_cap); ?></div>
                                </td>
                                <td class="px-6 py-4">
                                    <div class="flex space-x-2">
                                        <a href="<?php echo e(route('stocks.show', $stock)); ?>" 
                                           class="w-8 h-8 flex items-center justify-center text-blue-600 hover:text-blue-800 hover:bg-blue-50 rounded-lg transition-colors duration-200"
                                           title="View Details">
                                            <i data-lucide="eye" class="w-4 h-4"></i>
                                        </a>
                                        <a href="<?php echo e(route('trading.buy', $stock)); ?>" 
                                           class="w-8 h-8 flex items-center justify-center text-green-600 hover:text-green-800 hover:bg-green-50 rounded-lg transition-colors duration-200"
                                           title="Buy Stock">
                                            <i data-lucide="plus" class="w-4 h-4"></i>
                                        </a>
                                        <?php if(auth()->check()): ?>
                                            <?php
                                                $isInWatchlist = auth()->user()->stockWatchlist()->where('stock_id', $stock->id)->exists();
                                            ?>
                                            <?php if($isInWatchlist): ?>
                                                <form action="<?php echo e(route('trading.watchlist.remove', $stock)); ?>" method="POST" class="inline">
                                                    <?php echo csrf_field(); ?>
                                                    <?php echo method_field('DELETE'); ?>
                                                    <button type="submit" 
                                                            class="w-8 h-8 flex items-center justify-center text-red-600 hover:text-red-800 hover:bg-red-50 rounded-lg transition-colors duration-200"
                                                            onclick="return confirm('Remove <?php echo e($stock->symbol); ?> from watchlist?')"
                                                            title="Remove from Watchlist">
                                                        <i data-lucide="eye-off" class="w-4 h-4"></i>
                                                    </button>
                                                </form>
                                            <?php else: ?>
                                                <form action="<?php echo e(route('trading.watchlist.add', $stock)); ?>" method="POST" class="inline">
                                                    <?php echo csrf_field(); ?>
                                                    <button type="submit" 
                                                            class="w-8 h-8 flex items-center justify-center text-purple-600 hover:text-purple-800 hover:bg-purple-50 rounded-lg transition-colors duration-200"
                                                            title="Add to Watchlist">
                                                        <i data-lucide="eye" class="w-4 h-4"></i>
                                                    </button>
                                                </form>
                                            <?php endif; ?>
                                        <?php endif; ?>
                                    </div>
                                </td>
                            </tr>
                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                        </tbody>
                    </table>
                </div>

                <!-- Pagination -->
                <div class="px-6 py-4 border-t border-gray-100 dark:border-blue-600">
                    <?php echo e($stocks->links()); ?>

                </div>
            <?php else: ?>
                <div class="text-center py-12">
                    <div class="w-16 h-16 bg-gray-100 dark:bg-blue-600 rounded-full flex items-center justify-center mx-auto mb-4">
                        <i data-lucide="bar-chart-3" class="w-8 h-8 text-gray-400 dark:text-blue-200"></i>
                    </div>
                    <h3 class="text-lg font-light text-black dark:text-white mb-2">No stocks found</h3>
                    <p class="text-gray-600 text-sm mb-4">Try adjusting your search criteria</p>
                    <a href="<?php echo e(route('stocks.index')); ?>" class="inline-flex items-center px-4 py-2 bg-black dark:bg-white text-white dark:text-blue-900 text-sm font-medium rounded-lg hover:bg-gray-800 dark:hover:bg-blue-50 transition-colors duration-200">
                        <i data-lucide="refresh-cw" class="w-4 h-4 mr-2"></i>
                        Clear Filters
                    </a>
                </div>
            <?php endif; ?>
        </div>
    </div>
 <?php echo $__env->renderComponent(); ?>
<?php endif; ?>
<?php if (isset($__attributesOriginal951024bfcf58033c82ac11d797616473)): ?>
<?php $attributes = $__attributesOriginal951024bfcf58033c82ac11d797616473; ?>
<?php unset($__attributesOriginal951024bfcf58033c82ac11d797616473); ?>
<?php endif; ?>
<?php if (isset($__componentOriginal951024bfcf58033c82ac11d797616473)): ?>
<?php $component = $__componentOriginal951024bfcf58033c82ac11d797616473; ?>
<?php unset($__componentOriginal951024bfcf58033c82ac11d797616473); ?>
<?php endif; ?> 
<?php /**PATH /home/hyipcode/my.hyipcoders.info/resources/views/stocks/index.blade.php ENDPATH**/ ?>