<?php if (isset($component)) { $__componentOriginal91fdd17964e43374ae18c674f95cdaa3 = $component; } ?>
<?php if (isset($attributes)) { $__attributesOriginal91fdd17964e43374ae18c674f95cdaa3 = $attributes; } ?>
<?php $component = App\View\Components\AdminLayout::resolve([] + (isset($attributes) && $attributes instanceof Illuminate\View\ComponentAttributeBag ? $attributes->all() : [])); ?>
<?php $component->withName('admin-layout'); ?>
<?php if ($component->shouldRender()): ?>
<?php $__env->startComponent($component->resolveView(), $component->data()); ?>
<?php if (isset($attributes) && $attributes instanceof Illuminate\View\ComponentAttributeBag): ?>
<?php $attributes = $attributes->except(\App\View\Components\AdminLayout::ignoredParameterNames()); ?>
<?php endif; ?>
<?php $component->withAttributes([]); ?>
     <?php $__env->slot('header', null, []); ?> 
        <div class="flex justify-between items-center">
            <div>
                <h2 class="font-light text-lg text-black leading-tight mr-4">
                    Site Settings
                </h2>
            </div>
            <div class="flex space-x-2">
                <form method="POST" action="<?php echo e(route('admin.settings.clear-cache')); ?>" class="inline">
                    <?php echo csrf_field(); ?>
                    <button type="submit" class="px-3 py-2 bg-yellow-600 text-white text-sm font-medium rounded-lg hover:bg-yellow-700 transition-colors">
                        Clear Cache
                    </button>
                </form>
                <form method="POST" action="<?php echo e(route('admin.settings.reset-defaults')); ?>" class="inline">
                    <?php echo csrf_field(); ?>
                    <button type="submit" onclick="return confirm('Are you sure you want to reset all settings to defaults? This action cannot be undone.')" 
                            class="px-3 py-2 bg-red-600 text-white text-sm font-medium rounded-lg hover:bg-red-700 transition-colors">
                        Reset to Defaults
                    </button>
                </form>
            </div>
        </div>
     <?php $__env->endSlot(); ?>

    <div class="py-6">
        <div class="max-w-6xl mx-auto sm:px-6 lg:px-8">
            <form method="POST" action="<?php echo e(route('admin.settings.update')); ?>" enctype="multipart/form-data">
                <?php echo csrf_field(); ?>
                
                <!-- Settings Groups -->
                <div class="space-y-6">
                    <?php $__currentLoopData = $settings; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $group => $groupSettings): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                    <div class="bg-white border border-gray-200 dark:border-blue-600 overflow-hidden rounded-lg">
                        <div class="px-4 py-3 border-b border-gray-200 dark:border-blue-600 bg-gray-50">
                            <h3 class="text-base font-medium text-black capitalize"><?php echo e(str_replace('_', ' ', $group)); ?> Settings</h3>
                        </div>
                        <div class="p-6">
                            <div class="grid grid-cols-1 md:grid-cols-2 gap-6">
                                <?php $__currentLoopData = $groupSettings; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $setting): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                <div class="space-y-2">
                                    <label class="block text-sm font-medium text-gray-700">
                                        <?php echo e($setting->label); ?>

                                        <?php if($setting->description): ?>
                                            <span class="text-xs text-gray-500 block font-normal mt-1"><?php echo e($setting->description); ?></span>
                                        <?php endif; ?>
                                    </label>

                                    <?php if($setting->isCheckbox()): ?>
                                        <div class="flex items-center">
                                            <input type="hidden" name="settings[<?php echo e($setting->key); ?>]" value="0">
                                            <input type="checkbox" 
                                                   name="settings[<?php echo e($setting->key); ?>]" 
                                                   value="1" 
                                                   <?php echo e($setting->value == '1' ? 'checked' : ''); ?>

                                                   class="w-4 h-4 text-black border-gray-300 rounded focus:ring-black focus:ring-2">
                                            <span class="ml-2 text-sm text-gray-600 dark:text-blue-100">Enable <?php echo e($setting->label); ?></span>
                                        </div>
                                    <?php elseif($setting->isImage()): ?>
                                        <div class="space-y-3">
                                            <?php if($setting->value): ?>
                                                <div class="flex items-center space-x-3">
                                                    <?php if(in_array(pathinfo($setting->value, PATHINFO_EXTENSION), ['svg', 'ico'])): ?>
                                                        <div class="w-16 h-16 bg-gray-100 dark:bg-blue-600 rounded-lg flex items-center justify-center">
                                                            <img src="<?php echo e(asset('storage/' . $setting->value)); ?>" 
                                                                 alt="<?php echo e($setting->label); ?>" 
                                                                 class="w-12 h-12 object-contain">
                                                        </div>
                                                    <?php else: ?>
                                                        <img src="<?php echo e(asset('storage/' . $setting->value)); ?>" 
                                                             alt="<?php echo e($setting->label); ?>" 
                                                             class="w-16 h-16 object-cover rounded-lg">
                                                    <?php endif; ?>
                                                    <div>
                                                        <p class="text-xs text-gray-600 dark:text-blue-100">Current <?php echo e($setting->label); ?></p>
                                                        <p class="text-xs text-gray-500 dark:text-blue-200"><?php echo e(basename($setting->value)); ?></p>
                                                    </div>
                                                </div>
                                            <?php endif; ?>
                                            <input type="file" 
                                                   name="file_<?php echo e($setting->key); ?>" 
                                                   accept="image/*,.svg,.ico"
                                                   class="block w-full text-sm text-gray-500 file:mr-4 file:py-2 file:px-4 file:rounded-lg file:border-0 file:text-sm file:font-medium file:bg-black file:text-white hover:file:bg-gray-800">
                                            <p class="text-xs text-gray-500 dark:text-blue-200">Upload new <?php echo e(strtolower($setting->label)); ?></p>
                                        </div>
                                    <?php elseif($setting->isTextarea()): ?>
                                        <textarea name="settings[<?php echo e($setting->key); ?>]" 
                                                  rows="3"
                                                  class="w-full px-3 py-2 border border-gray-300 rounded-lg focus:ring-black focus:border-black text-sm"><?php echo e($setting->value); ?></textarea>
                                    <?php else: ?>
                                        <input type="text" 
                                               name="settings[<?php echo e($setting->key); ?>]" 
                                               value="<?php echo e($setting->value); ?>"
                                               class="w-full px-3 py-2 border border-gray-300 rounded-lg focus:ring-black focus:border-black text-sm">
                                    <?php endif; ?>
                                </div>
                                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                            </div>
                        </div>
                    </div>
                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                </div>

                <!-- Submit Button -->
                <div class="mt-6 flex justify-end">
                    <button type="submit" class="px-6 py-3 bg-black dark:bg-white text-white dark:text-blue-900 text-sm font-medium rounded-lg hover:bg-gray-800 dark:hover:bg-blue-50 transition-colors">
                        <svg class="w-4 h-4 mr-2 inline" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                            <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M5 13l4 4L19 7"></path>
                        </svg>
                        Save Settings
                    </button>
                </div>
            </form>
        </div>
    </div>

    <!-- Settings Preview -->
    <div class="py-6 border-t border-gray-200 dark:border-blue-600">
        <div class="max-w-6xl mx-auto sm:px-6 lg:px-8">
            <div class="bg-white border border-gray-200 dark:border-blue-600 overflow-hidden rounded-lg">
                <div class="px-4 py-3 border-b border-gray-200 dark:border-blue-600 bg-gray-50">
                    <h3 class="text-base font-medium text-black">Settings Preview</h3>
                    <p class="text-xs text-gray-600 mt-1">How your settings will appear on the frontend</p>
                </div>
                <div class="p-6">
                    <div class="grid grid-cols-1 md:grid-cols-2 gap-6">
                        <div>
                            <h4 class="text-sm font-medium text-gray-700 mb-3">Site Information</h4>
                            <div class="space-y-2 text-sm">
                                <div>
                                    <span class="font-medium text-gray-600 dark:text-blue-100">Site Name:</span>
                                    <span class="ml-2 text-black"><?php echo e($settings['general']->where('key', 'site_name')->first()?->value ?? 'Not set'); ?></span>
                                </div>
                                <div>
                                    <span class="font-medium text-gray-600 dark:text-blue-100">Site URL:</span>
                                    <span class="ml-2 text-black"><?php echo e($settings['general']->where('key', 'site_url')->first()?->value ?? 'Not set'); ?></span>
                                </div>
                                <div>
                                    <span class="font-medium text-gray-600 dark:text-blue-100">Site Email:</span>
                                    <span class="ml-2 text-black"><?php echo e($settings['general']->where('key', 'site_email')->first()?->value ?? 'Not set'); ?></span>
                                </div>
                                <div>
                                    <span class="font-medium text-gray-600 dark:text-blue-100">Site Phone:</span>
                                    <span class="ml-2 text-black"><?php echo e($settings['general']->where('key', 'site_phone')->first()?->value ?? 'Not set'); ?></span>
                                </div>
                            </div>
                        </div>
                        <div>
                            <h4 class="text-sm font-medium text-gray-700 mb-3">Security Settings</h4>
                            <div class="space-y-2 text-sm">
                                <div>
                                    <span class="font-medium text-gray-600 dark:text-blue-100">KYC Verification:</span>
                                    <span class="ml-2 <?php echo e($settings['security']->where('key', 'enable_kyc')->first()?->value == '1' ? 'text-green-600' : 'text-red-600'); ?>">
                                        <?php echo e($settings['security']->where('key', 'enable_kyc')->first()?->value == '1' ? 'Enabled' : 'Disabled'); ?>

                                    </span>
                                </div>
                                <div>
                                    <span class="font-medium text-gray-600 dark:text-blue-100">Email Verification:</span>
                                    <span class="ml-2 <?php echo e($settings['security']->where('key', 'enable_email_verification')->first()?->value == '1' ? 'text-green-600' : 'text-red-600'); ?>">
                                        <?php echo e($settings['security']->where('key', 'enable_email_verification')->first()?->value == '1' ? 'Enabled' : 'Disabled'); ?>

                                    </span>
                                </div>
                                <div>
                                    <span class="font-medium text-gray-600 dark:text-blue-100">Maintenance Mode:</span>
                                    <span class="ml-2 <?php echo e($settings['general']->where('key', 'maintenance_mode')->first()?->value == '1' ? 'text-red-600' : 'text-green-600'); ?>">
                                        <?php echo e($settings['general']->where('key', 'maintenance_mode')->first()?->value == '1' ? 'Enabled' : 'Disabled'); ?>

                                    </span>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
 <?php echo $__env->renderComponent(); ?>
<?php endif; ?>
<?php if (isset($__attributesOriginal91fdd17964e43374ae18c674f95cdaa3)): ?>
<?php $attributes = $__attributesOriginal91fdd17964e43374ae18c674f95cdaa3; ?>
<?php unset($__attributesOriginal91fdd17964e43374ae18c674f95cdaa3); ?>
<?php endif; ?>
<?php if (isset($__componentOriginal91fdd17964e43374ae18c674f95cdaa3)): ?>
<?php $component = $__componentOriginal91fdd17964e43374ae18c674f95cdaa3; ?>
<?php unset($__componentOriginal91fdd17964e43374ae18c674f95cdaa3); ?>
<?php endif; ?>
<?php /**PATH /home/hyipcode/my.hyipcoders.info/resources/views/admin/settings/index.blade.php ENDPATH**/ ?>