<?php if (isset($component)) { $__componentOriginal951024bfcf58033c82ac11d797616473 = $component; } ?>
<?php if (isset($attributes)) { $__attributesOriginal951024bfcf58033c82ac11d797616473 = $attributes; } ?>
<?php $component = App\View\Components\UserLayout::resolve([] + (isset($attributes) && $attributes instanceof Illuminate\View\ComponentAttributeBag ? $attributes->all() : [])); ?>
<?php $component->withName('user-layout'); ?>
<?php if ($component->shouldRender()): ?>
<?php $__env->startComponent($component->resolveView(), $component->data()); ?>
<?php if (isset($attributes) && $attributes instanceof Illuminate\View\ComponentAttributeBag): ?>
<?php $attributes = $attributes->except(\App\View\Components\UserLayout::ignoredParameterNames()); ?>
<?php endif; ?>
<?php $component->withAttributes([]); ?>
     <?php $__env->slot('header', null, []); ?> 
        Portfolio Overview
     <?php $__env->endSlot(); ?>

    <div class="max-w-7xl mx-auto">
        <!-- Enhanced Header -->
        <div class="bg-gradient-to-br from-blue-600 via-blue-700 to-blue-800 dark:from-blue-700 dark:via-blue-800 dark:to-blue-900 rounded-2xl p-6 mb-6 text-white relative overflow-hidden">
            <!-- Background Pattern -->
            <div class="absolute inset-0 opacity-10">
                <div class="absolute top-0 right-0 w-48 h-48 bg-white rounded-full -translate-y-24 translate-x-24"></div>
                <div class="absolute bottom-0 left-0 w-24 h-24 bg-white rounded-full translate-y-12 -translate-x-12"></div>
            </div>
            
            <div class="relative z-10">
                <div class="flex flex-col lg:flex-row lg:items-center lg:justify-between">
                    <div class="mb-4 lg:mb-0 lg:flex-1">
                        <div class="flex items-center mb-1">
                            <h1 class="text-xl font-light">Portfolio Overview</h1>
                            <div class="ml-3 real-time-indicator">
                                <span class="inline-flex items-center px-2 py-0.5 rounded-full text-xs font-medium bg-green-900 text-green-300">
                                    <i data-lucide="radio" class="w-3 h-3 mr-1"></i>
                                    Live
                                </span>
                            </div>
                        </div>
                        <p class="text-blue-100 dark:text-blue-200 text-sm">Track your investment performance and holdings</p>
                        <p class="text-xs text-gray-400 mt-1">Last updated: <span data-last-updated><?php echo e(now()->format('H:i:s')); ?></span></p>
                    </div>
                    
                    <!-- Enhanced Stats Card -->
                    <div class="bg-white bg-opacity-15 backdrop-blur-xl rounded-xl p-4 border border-white border-opacity-20 shadow-xl lg:w-80">
                        <div class="flex items-center justify-between mb-3">
                            <div>
                                <p class="text-xs text-blue-100 dark:text-blue-200 mb-1">Total Value</p>
                                <p class="text-lg font-light" data-portfolio-total-value="<?php echo e(currency_symbol()); ?><?php echo e(number_format($totalCurrentValue, 2)); ?>"><?php echo e(currency_symbol()); ?><?php echo e(number_format($totalCurrentValue, 2)); ?></p>
                            </div>
                            <div class="w-10 h-10 flex items-center justify-center">
                                <i data-lucide="trending-up" class="w-5 h-5 text-white"></i>
                            </div>
                        </div>
                        <div class="flex space-x-4 text-xs">
                            <div class="flex-1 text-center">
                                <p class="text-blue-100 dark:text-blue-200">Invested</p>
                                <p class="text-white font-medium" data-portfolio-total-cost="<?php echo e(currency_symbol()); ?><?php echo e(number_format($totalInvested, 2)); ?>"><?php echo e(currency_symbol()); ?><?php echo e(number_format($totalInvested, 2)); ?></p>
                            </div>
                            <div class="flex-1 text-center">
                                <p class="text-blue-100 dark:text-blue-200">Gain/Loss</p>
                                <p class="text-white font-medium <?php echo e($totalGainLoss >= 0 ? 'text-green-400' : 'text-red-400'); ?>" data-portfolio-total-gain-loss="<?php echo e(currency_symbol()); ?><?php echo e(number_format($totalGainLoss, 2)); ?>">
                                    <?php echo e($totalGainLoss >= 0 ? '+' : ''); ?><?php echo e(currency_symbol()); ?><?php echo e(number_format($totalGainLoss, 2)); ?>

                                </p>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>

        <!-- Portfolio Navigation -->
        <div class="bg-white dark:bg-blue-700 rounded-xl p-4 shadow-sm border border-gray-100 mb-6">
            <div class="flex items-center justify-between mb-4">
                <div>
                    <h3 class="text-lg font-light text-black dark:text-white mb-1">Portfolio Tools</h3>
                    <p class="text-xs text-gray-500 dark:text-blue-200">Access detailed portfolio analysis and management</p>
                </div>
            </div>
            
            <div class="grid grid-cols-1 md:grid-cols-4 gap-3">
                <a href="<?php echo e(route('portfolio.holdings')); ?>" class="group bg-gray-50 dark:bg-blue-600 rounded-lg p-4 hover:bg-gray-100 dark:hover:bg-blue-500 transition-all duration-300">
                    <div class="flex items-center justify-between mb-2">
                        <div class="w-8 h-8 flex items-center justify-center">
                            <i data-lucide="pie-chart" class="w-4 h-4 text-blue-600"></i>
                        </div>
                        <i data-lucide="arrow-right" class="w-4 h-4 text-gray-400 group-hover:text-gray-600 transition-colors duration-200"></i>
                    </div>
                    <h4 class="text-sm font-medium text-black dark:text-white mb-1">Holdings</h4>
                    <p class="text-xs text-gray-500 dark:text-blue-200">Detailed holdings breakdown</p>
                </a>

                <a href="<?php echo e(route('portfolio.analytics')); ?>" class="group bg-gray-50 dark:bg-blue-600 rounded-lg p-4 hover:bg-gray-100 dark:hover:bg-blue-500 transition-all duration-300">
                    <div class="flex items-center justify-between mb-2">
                        <div class="w-8 h-8 flex items-center justify-center">
                            <i data-lucide="bar-chart-3" class="w-4 h-4 text-green-600"></i>
                        </div>
                        <i data-lucide="arrow-right" class="w-4 h-4 text-gray-400 group-hover:text-gray-600 transition-colors duration-200"></i>
                    </div>
                    <h4 class="text-sm font-medium text-black dark:text-white mb-1">Analytics</h4>
                    <p class="text-xs text-gray-500 dark:text-blue-200">Performance charts & analysis</p>
                </a>

                <a href="<?php echo e(route('portfolio.transactions')); ?>" class="group bg-gray-50 dark:bg-blue-600 rounded-lg p-4 hover:bg-gray-100 dark:hover:bg-blue-500 transition-all duration-300">
                    <div class="flex items-center justify-between mb-2">
                        <div class="w-8 h-8 flex items-center justify-center">
                            <i data-lucide="activity" class="w-4 h-4 text-purple-600"></i>
                        </div>
                        <i data-lucide="arrow-right" class="w-4 h-4 text-gray-400 group-hover:text-gray-600 transition-colors duration-200"></i>
                    </div>
                    <h4 class="text-sm font-medium text-black dark:text-white mb-1">Transactions</h4>
                    <p class="text-xs text-gray-500 dark:text-blue-200">Complete transaction history</p>
                </a>

                <a href="<?php echo e(route('investment.dashboard')); ?>" class="group bg-gray-50 dark:bg-blue-600 rounded-lg p-4 hover:bg-gray-100 dark:hover:bg-blue-500 transition-all duration-300">
                    <div class="flex items-center justify-between mb-2">
                        <div class="w-8 h-8 flex items-center justify-center">
                            <i data-lucide="layout-dashboard" class="w-4 h-4 text-orange-600"></i>
                        </div>
                        <i data-lucide="arrow-right" class="w-4 h-4 text-gray-400 group-hover:text-gray-600 transition-colors duration-200"></i>
                    </div>
                    <h4 class="text-sm font-medium text-black dark:text-white mb-1">Dashboard</h4>
                    <p class="text-xs text-gray-500 dark:text-blue-200">Investment dashboard overview</p>
                </a>
            </div>
        </div>

        <!-- Portfolio Performance -->
        <div class="grid grid-cols-1 md:grid-cols-3 gap-4 mb-6">
            <!-- Total Invested -->
            <div class="bg-white dark:bg-blue-700 rounded-xl p-4 shadow-sm border border-gray-100 dark:border-blue-600">
                <div class="flex items-center justify-between mb-3">
                    <div>
                        <p class="text-xs text-gray-500 dark:text-blue-100 mb-1">Total Invested</p>
                        <p class="text-lg font-light text-black"><?php echo e(currency_symbol()); ?><?php echo e(number_format($totalInvested, 2)); ?></p>
                    </div>
                    <div class="w-8 h-8 flex items-center justify-center">
                        <i data-lucide="dollar-sign" class="w-4 h-4 text-blue-600"></i>
                    </div>
                </div>
            </div>

            <!-- Current Value -->
            <div class="bg-white dark:bg-blue-700 rounded-xl p-4 shadow-sm border border-gray-100 dark:border-blue-600">
                <div class="flex items-center justify-between mb-3">
                    <div>
                        <p class="text-xs text-gray-500 dark:text-blue-100 mb-1">Current Value</p>
                        <p class="text-lg font-light text-black"><?php echo e(currency_symbol()); ?><?php echo e(number_format($totalCurrentValue, 2)); ?></p>
                    </div>
                    <div class="w-8 h-8 flex items-center justify-center">
                        <i data-lucide="trending-up" class="w-4 h-4 text-green-600"></i>
                    </div>
                </div>
            </div>

            <!-- Total Gain/Loss -->
            <div class="bg-white dark:bg-blue-700 rounded-xl p-4 shadow-sm border border-gray-100 dark:border-blue-600">
                <div class="flex items-center justify-between mb-3">
                    <div>
                        <p class="text-xs text-gray-500 dark:text-blue-100 mb-1">Total Gain/Loss</p>
                        <p class="text-lg font-light <?php echo e($totalGainLoss >= 0 ? 'text-green-600' : 'text-red-600'); ?>">
                            <?php echo e($totalGainLoss >= 0 ? '+' : ''); ?><?php echo e(currency_symbol()); ?><?php echo e(number_format($totalGainLoss, 2)); ?>

                        </p>
                        <p class="text-xs <?php echo e($totalGainLoss >= 0 ? 'text-green-600' : 'text-red-600'); ?>">
                            <?php echo e($totalGainLossPercentage >= 0 ? '+' : ''); ?><?php echo e(number_format($totalGainLossPercentage, 2)); ?>%
                        </p>
                    </div>
                    <div class="w-8 h-8 flex items-center justify-center">
                        <i data-lucide="<?php echo e($totalGainLoss >= 0 ? 'arrow-up' : 'arrow-down'); ?>" class="w-4 h-4 <?php echo e($totalGainLoss >= 0 ? 'text-green-600' : 'text-red-600'); ?>"></i>
                    </div>
                </div>
            </div>
        </div>

        <!-- Holdings Section -->
        <div class="bg-white dark:bg-blue-700 rounded-xl p-6 shadow-sm border border-gray-100 mb-6">
            <div class="flex items-center justify-between mb-4">
                <div>
                    <h3 class="text-lg font-light text-black dark:text-white mb-1">Your Holdings</h3>
                    <p class="text-xs text-gray-500 dark:text-blue-200"><?php echo e($holdings->count()); ?> investment plans</p>
                </div>
                <a href="<?php echo e(route('portfolio.holdings')); ?>" class="text-xs text-blue-600 hover:text-blue-800 transition-colors duration-200 font-medium">
                    Browse More
                    <i data-lucide="arrow-right" class="w-3 h-3 inline ml-1"></i>
                </a>
            </div>
            
            <?php if($holdings->count() > 0): ?>
                <div class="space-y-3">
                    <?php $__currentLoopData = $holdings; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $holding): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                    <div class="group bg-gray-50 dark:bg-blue-600 rounded-lg p-4 hover:bg-gray-100 dark:hover:bg-blue-500 transition-all duration-300">
                        <div class="flex items-start justify-between mb-3">
                            <div class="flex-1">
                                <h4 class="font-medium text-black dark:text-white text-sm mb-1"><?php echo e($holding->investmentPlan->name); ?></h4>
                                <p class="text-xs text-gray-600 dark:text-blue-100"><?php echo e($holding->investmentPlan->category); ?></p>
                            </div>
                            <span class="inline-flex items-center px-2 py-0.5 rounded-full text-xs font-medium <?php echo e($holding->investmentPlan->risk_level_badge); ?>">
                                <?php echo e(ucfirst($holding->investmentPlan->risk_level)); ?>

                            </span>
                        </div>
                        
                        <div class="grid grid-cols-2 md:grid-cols-4 gap-3 mb-3">
                            <div>
                                <p class="text-xs text-gray-500 dark:text-blue-200">Units</p>
                                <p class="text-xs font-medium text-black"><?php echo e(number_format($holding->units, 4)); ?></p>
                            </div>
                            <div>
                                <p class="text-xs text-gray-500 dark:text-blue-200">Value</p>
                                <p class="text-xs font-medium text-black"><?php echo e(currency_symbol()); ?><?php echo e(number_format($holding->current_value, 2)); ?></p>
                            </div>
                            <div>
                                <p class="text-xs text-gray-500 dark:text-blue-200">Gain/Loss</p>
                                <p class="text-xs font-medium <?php echo e($holding->unrealized_gain_loss >= 0 ? 'text-green-600' : 'text-red-600'); ?>">
                                    <?php echo e($holding->unrealized_gain_loss >= 0 ? '+' : ''); ?><?php echo e(currency_symbol()); ?><?php echo e(number_format($holding->unrealized_gain_loss, 2)); ?>

                                </p>
                            </div>
                            <div>
                                <p class="text-xs text-gray-500 dark:text-blue-200">Return</p>
                                <p class="text-xs font-medium <?php echo e($holding->unrealized_gain_loss_percentage >= 0 ? 'text-green-600' : 'text-red-600'); ?>">
                                    <?php echo e($holding->unrealized_gain_loss_percentage >= 0 ? '+' : ''); ?><?php echo e(number_format($holding->unrealized_gain_loss_percentage, 2)); ?>%
                                </p>
                            </div>
                        </div>
                        
                        <div class="flex items-center justify-between">
                            <a href="<?php echo e(route('investments.show', $holding->investmentPlan)); ?>" class="text-xs text-blue-600 hover:text-blue-800 transition-colors duration-200">
                                View Details
                            </a>
                            <div class="flex space-x-2">
                                <a href="<?php echo e(route('investments.buy', $holding->investmentPlan)); ?>" class="px-2 py-1 bg-black dark:bg-white text-white dark:text-blue-900 text-xs font-medium rounded transition-colors duration-200 hover:bg-gray-800">
                                    Buy More
                                </a>
                                <?php if($holding->units > 0): ?>
                                <a href="<?php echo e(route('investments.sell', $holding->investmentPlan)); ?>" class="px-2 py-1 border border-gray-300 text-black text-xs font-medium rounded transition-colors duration-200 hover:bg-gray-50">
                                    Sell
                                </a>
                                <?php endif; ?>
                            </div>
                        </div>
                    </div>
                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                </div>
            <?php else: ?>
                <div class="text-center py-8">
                    <div class="w-12 h-12 bg-gray-100 dark:bg-blue-600 rounded-full flex items-center justify-center mx-auto mb-3">
                        <i data-lucide="trending-up" class="w-6 h-6 text-gray-400 dark:text-blue-200"></i>
                    </div>
                    <h3 class="text-base font-light text-black dark:text-white mb-1">No holdings yet</h3>
                    <p class="text-gray-600 text-xs mb-3">Start building your portfolio by investing in our plans</p>
                    <a href="<?php echo e(route('investments.index')); ?>" class="inline-flex items-center px-4 py-2 bg-black dark:bg-white text-white dark:text-blue-900 text-xs font-medium rounded-lg hover:bg-gray-800 dark:hover:bg-blue-50 transition-colors duration-200">
                        <i data-lucide="plus" class="w-3 h-3 mr-1"></i>
                        Start Investing
                    </a>
                </div>
            <?php endif; ?>
        </div>

        <!-- Recent Transactions -->
        <div class="bg-white dark:bg-blue-700 rounded-xl p-6 shadow-sm border border-gray-100 dark:border-blue-600">
            <div class="flex items-center justify-between mb-4">
                <div>
                    <h3 class="text-lg font-light text-black dark:text-white mb-1">Recent Transactions</h3>
                    <p class="text-xs text-gray-500 dark:text-blue-200">Your latest investment activity</p>
                </div>
                <a href="<?php echo e(route('wallet.transactions')); ?>" class="text-xs text-blue-600 hover:text-blue-800 transition-colors duration-200 font-medium">
                    View All
                    <i data-lucide="arrow-right" class="w-3 h-3 inline ml-1"></i>
                </a>
            </div>
            
            <?php if($recentTransactions->count() > 0): ?>
                <div class="space-y-3">
                    <?php $__currentLoopData = $recentTransactions; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $transaction): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                    <div class="flex items-center space-x-3 p-3 bg-gray-50 dark:bg-blue-600 rounded-lg">
                        <div class="w-8 h-8 flex items-center justify-center">
                            <?php if($transaction->type === 'buy'): ?>
                                <i data-lucide="plus" class="w-4 h-4 text-green-500"></i>
                            <?php else: ?>
                                <i data-lucide="minus" class="w-4 h-4 text-red-500"></i>
                            <?php endif; ?>
                        </div>
                        <div class="flex-1 min-w-0">
                            <p class="text-xs font-medium text-black"><?php echo e($transaction->investmentPlan->name); ?></p>
                            <p class="text-xs text-gray-500 dark:text-blue-200"><?php echo e($transaction->type_label); ?> • <?php echo e($transaction->formatted_executed_at); ?></p>
                        </div>
                        <div class="text-right">
                            <p class="text-xs font-medium text-black"><?php echo e(currency_symbol()); ?><?php echo e(number_format($transaction->total_amount, 2)); ?></p>
                            <p class="text-xs text-gray-500 dark:text-blue-200"><?php echo e(number_format($transaction->units, 4)); ?> units</p>
                        </div>
                    </div>
                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                </div>
            <?php else: ?>
                <div class="text-center py-6">
                    <div class="w-8 h-8 bg-gray-100 dark:bg-blue-600 rounded-full flex items-center justify-center mx-auto mb-2">
                        <i data-lucide="activity" class="w-4 h-4 text-gray-400 dark:text-blue-200"></i>
                    </div>
                    <p class="text-xs text-gray-500 dark:text-blue-200">No recent transactions</p>
                </div>
            <?php endif; ?>
        </div>
    </div>
 <?php echo $__env->renderComponent(); ?>
<?php endif; ?>
<?php if (isset($__attributesOriginal951024bfcf58033c82ac11d797616473)): ?>
<?php $attributes = $__attributesOriginal951024bfcf58033c82ac11d797616473; ?>
<?php unset($__attributesOriginal951024bfcf58033c82ac11d797616473); ?>
<?php endif; ?>
<?php if (isset($__componentOriginal951024bfcf58033c82ac11d797616473)): ?>
<?php $component = $__componentOriginal951024bfcf58033c82ac11d797616473; ?>
<?php unset($__componentOriginal951024bfcf58033c82ac11d797616473); ?>
<?php endif; ?> 
<?php /**PATH /home/hyipcode/my.hyipcoders.info/resources/views/portfolio/index.blade.php ENDPATH**/ ?>