<?php if (isset($component)) { $__componentOriginal951024bfcf58033c82ac11d797616473 = $component; } ?>
<?php if (isset($attributes)) { $__attributesOriginal951024bfcf58033c82ac11d797616473 = $attributes; } ?>
<?php $component = App\View\Components\UserLayout::resolve([] + (isset($attributes) && $attributes instanceof Illuminate\View\ComponentAttributeBag ? $attributes->all() : [])); ?>
<?php $component->withName('user-layout'); ?>
<?php if ($component->shouldRender()): ?>
<?php $__env->startComponent($component->resolveView(), $component->data()); ?>
<?php if (isset($attributes) && $attributes instanceof Illuminate\View\ComponentAttributeBag): ?>
<?php $attributes = $attributes->except(\App\View\Components\UserLayout::ignoredParameterNames()); ?>
<?php endif; ?>
<?php $component->withAttributes([]); ?>
     <?php $__env->slot('header', null, []); ?> 
        Investment Plans
     <?php $__env->endSlot(); ?>

    <div class="max-w-7xl mx-auto">
        <!-- Enhanced Header -->
        <div class="bg-gradient-to-br from-blue-600 via-blue-700 to-blue-800 dark:from-blue-700 dark:via-blue-800 dark:to-blue-900 rounded-2xl p-6 mb-6 text-white relative overflow-hidden">
            <!-- Background Pattern -->
            <div class="absolute inset-0 opacity-10">
                <div class="absolute top-0 right-0 w-48 h-48 bg-white rounded-full -translate-y-24 translate-x-24"></div>
                <div class="absolute bottom-0 left-0 w-24 h-24 bg-white rounded-full translate-y-12 -translate-x-12"></div>
            </div>
            
            <div class="relative z-10">
                <div class="flex flex-col lg:flex-row lg:items-center lg:justify-between">
                    <div class="mb-4 lg:mb-0 lg:flex-1">
                        <h1 class="text-xl font-light mb-1">Investment Plans</h1>
                        <p class="text-blue-100 dark:text-blue-200 text-sm">Discover and invest in diversified portfolios designed for growth</p>
                    </div>
                    
                    <!-- Enhanced Stats Card -->
                    <div class="bg-white bg-opacity-15 backdrop-blur-xl rounded-xl p-4 border border-white border-opacity-20 shadow-xl lg:w-80">
                        <div class="flex items-center justify-between mb-3">
                            <div>
                                <p class="text-xs text-blue-100 dark:text-blue-200 mb-1">Available Plans</p>
                                <p class="text-lg font-light"><?php echo e($plans->total()); ?></p>
                            </div>
                            <div class="w-10 h-10 flex items-center justify-center">
                                <i data-lucide="trending-up" class="w-5 h-5 text-white"></i>
                            </div>
                        </div>
                        <div class="flex space-x-4 text-xs">
                            <div class="flex-1 text-center">
                                <p class="text-blue-100 dark:text-blue-200">Categories</p>
                                <p class="text-white font-medium"><?php echo e($categories->count()); ?></p>
                            </div>
                            <div class="flex-1 text-center">
                                <p class="text-blue-100 dark:text-blue-200">Featured</p>
                                <p class="text-white font-medium"><?php echo e($featuredPlans->total()); ?></p>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>

        <!-- Collapsible Search and Filters -->
        <div class="bg-blue-50 dark:bg-blue-700 rounded-xl shadow-sm border border-gray-100 mb-6">
            <div class="p-4">
                <button type="button" 
                        onclick="toggleFilters()" 
                        class="flex items-center justify-between w-full text-left">
                    <div class="flex items-center">
                        <i data-lucide="filter" class="w-4 h-4 text-gray-600 mr-2"></i>
                        <span class="text-sm font-medium text-black">Search & Filters</span>
                    </div>
                    <i data-lucide="chevron-down" id="filterIcon" class="w-4 h-4 text-gray-600 transition-transform duration-200"></i>
                </button>
            </div>
            
            <div id="filterSection" class="hidden border-t border-gray-100 dark:border-blue-600">
                <form method="GET" class="p-6">
                    <div class="grid grid-cols-1 md:grid-cols-4 gap-4">
                        <!-- Search -->
                        <div class="md:col-span-2">
                            <label for="search" class="block text-sm font-medium text-gray-700 mb-2">Search Plans</label>
                            <div class="relative">
                                <i data-lucide="search" class="absolute left-3 top-1/2 transform -translate-y-1/2 w-4 h-4 text-gray-400 dark:text-blue-200"></i>
                                <input type="text" 
                                       id="search" 
                                       name="search" 
                                       value="<?php echo e(request('search')); ?>"
                                       class="w-full pl-10 pr-4 py-3 border border-gray-300 rounded-lg focus:ring-2 focus:ring-black focus:border-transparent transition-colors duration-200"
                                       placeholder="Search by name, category, or description">
                            </div>
                        </div>

                        <!-- Category Filter -->
                        <div>
                            <label for="category" class="block text-sm font-medium text-gray-700 mb-2">Category</label>
                            <select id="category" name="category" class="w-full px-4 py-3 border border-gray-300 rounded-lg focus:ring-2 focus:ring-black focus:border-transparent transition-colors duration-200">
                                <option value="">All Categories</option>
                                <?php $__currentLoopData = $categories; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $category): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                    <option value="<?php echo e($category); ?>" <?php echo e(request('category') == $category ? 'selected' : ''); ?>><?php echo e($category); ?></option>
                                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                            </select>
                        </div>

                        <!-- Risk Level Filter -->
                        <div>
                            <label for="risk_level" class="block text-sm font-medium text-gray-700 mb-2">Risk Level</label>
                            <select id="risk_level" name="risk_level" class="w-full px-4 py-3 border border-gray-300 rounded-lg focus:ring-2 focus:ring-black focus:border-transparent transition-colors duration-200">
                                <option value="">All Risk Levels</option>
                                <option value="conservative" <?php echo e(request('risk_level') == 'conservative' ? 'selected' : ''); ?>>Conservative</option>
                                <option value="moderate" <?php echo e(request('risk_level') == 'moderate' ? 'selected' : ''); ?>>Moderate</option>
                                <option value="aggressive" <?php echo e(request('risk_level') == 'aggressive' ? 'selected' : ''); ?>>Aggressive</option>
                            </select>
                        </div>

                        <!-- Sort By -->
                        <div>
                            <label for="sort" class="block text-sm font-medium text-gray-700 mb-2">Sort By</label>
                            <select id="sort" name="sort" class="w-full px-4 py-3 border border-gray-300 rounded-lg focus:ring-2 focus:ring-black focus:border-transparent transition-colors duration-200">
                                <option value="name" <?php echo e(request('sort') == 'name' ? 'selected' : ''); ?>>Name A-Z</option>
                                <option value="performance" <?php echo e(request('sort') == 'performance' ? 'selected' : ''); ?>>Best Performance</option>
                                <option value="nav" <?php echo e(request('sort') == 'nav' ? 'selected' : ''); ?>>Lowest NAV</option>
                                <option value="risk" <?php echo e(request('sort') == 'risk' ? 'selected' : ''); ?>>Risk Level</option>
                            </select>
                        </div>

                        <!-- Filter Buttons -->
                        <div class="md:col-span-4 flex space-x-3">
                            <button type="submit" class="px-4 py-2 bg-black dark:bg-white text-white dark:text-blue-900 text-sm font-medium rounded-lg hover:bg-gray-800 dark:hover:bg-blue-50 transition-colors duration-200 flex items-center">
                                <i data-lucide="filter" class="w-4 h-4 mr-2"></i>
                                Apply Filters
                            </button>
                            <a href="<?php echo e(route('investments.index')); ?>" class="px-4 py-2 border border-gray-300 text-black dark:text-white text-sm font-medium rounded-lg hover:bg-gray-50 transition-colors duration-200 flex items-center">
                                <i data-lucide="refresh-cw" class="w-4 h-4 mr-2"></i>
                                Clear Filters
                            </a>
                        </div>
                    </div>
                </form>
            </div>
        </div>

        <!-- Enhanced Featured Plans -->
        <?php if($featuredPlans->count() > 0): ?>
        <div class="mb-8">
            <div class="flex items-center justify-between mb-4">
                <h2 class="text-lg font-light text-black">Featured Plans</h2>
                <a href="#" class="text-xs text-black hover:text-gray-600 transition-colors duration-200 font-medium">
                    View All Featured
                    <i data-lucide="arrow-right" class="w-3 h-3 inline ml-1"></i>
                </a>
            </div>
            <div class="grid grid-cols-1 md:grid-cols-2 lg:grid-cols-3 gap-4">
                <?php $__currentLoopData = $featuredPlans; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $plan): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                <div class="group bg-blue-50 dark:bg-blue-700 rounded-xl p-5 shadow-sm border border-gray-100 hover:shadow-lg transition-all duration-300 hover:scale-105 relative overflow-hidden">
                    <div class="absolute inset-0 bg-gradient-to-br from-blue-50 to-blue-100 opacity-0 group-hover:opacity-100 transition-opacity duration-300"></div>
                    <div class="relative z-10">
                        <div class="flex items-start justify-between mb-4">
                            <div class="flex-1">
                                <h3 class="font-medium text-black text-lg mb-1"><?php echo e($plan->name); ?></h3>
                                <p class="text-sm text-gray-600 dark:text-blue-100"><?php echo e($plan->category); ?></p>
                            </div>
                            <span class="inline-flex items-center px-2 py-1 rounded-full text-xs font-medium <?php echo e($plan->risk_level_badge); ?>">
                                <?php echo e(ucfirst($plan->risk_level)); ?>

                            </span>
                        </div>
                        
                        <div class="space-y-3 mb-4">
                            <div class="flex justify-between">
                                <span class="text-sm text-gray-500 dark:text-blue-200">Current NAV:</span>
                                <span class="text-sm font-medium text-black"><?php echo e(currency_symbol()); ?><?php echo e(number_format($plan->nav, 4)); ?></span>
                            </div>
                            <div class="flex justify-between">
                                <span class="text-sm text-gray-500 dark:text-blue-200">1Y Return:</span>
                                <span class="text-sm font-medium <?php echo e($plan->nav_change_percentage >= 0 ? 'text-green-600' : 'text-red-600'); ?>">
                                    <?php echo e($plan->nav_change_percentage >= 0 ? '+' : ''); ?><?php echo e(number_format($plan->nav_change_percentage, 2)); ?>%
                                </span>
                            </div>
                            <div class="flex justify-between">
                                <span class="text-sm text-gray-500 dark:text-blue-200">Min Investment:</span>
                                <span class="text-sm font-medium text-black"><?php echo e(currency_symbol()); ?><?php echo e(number_format($plan->minimum_investment, 2)); ?></span>
                            </div>
                        </div>
                        
                        <div class="flex items-center justify-between">
                            <a href="<?php echo e(route('investments.show', $plan)); ?>" class="flex items-center text-blue-600 text-xs font-medium hover:text-blue-800 transition-colors duration-200">
                                <span>View Details</span>
                                <i data-lucide="arrow-right" class="w-3 h-3 ml-1 group-hover:translate-x-1 transition-transform duration-200"></i>
                            </a>
                            <a href="<?php echo e(route('investments.buy', $plan)); ?>" class="px-3 py-1 bg-black dark:bg-white text-white dark:text-blue-900 text-xs font-medium rounded-lg hover:bg-gray-800 dark:hover:bg-blue-50 transition-colors duration-200">
                                Invest Now
                            </a>
                        </div>
                    </div>
                </div>
                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
            </div>
            
            <!-- Featured Plans Pagination -->
            <?php if($featuredPlans->hasPages()): ?>
            <div class="mt-6">
                <?php echo e($featuredPlans->links()); ?>

            </div>
            <?php endif; ?>
        </div>
        <?php endif; ?>

        <!-- Enhanced All Plans -->
        <div class="bg-blue-50 dark:bg-blue-700 rounded-xl p-5 shadow-sm border border-gray-100 dark:border-blue-600">
            <div class="flex items-center justify-between mb-4">
                <div>
                    <h3 class="text-lg font-light text-black dark:text-white mb-1">All Investment Plans</h3>
                    <p class="text-xs text-gray-500 dark:text-blue-200">Showing <?php echo e($plans->count()); ?> of <?php echo e($plans->total()); ?> plans</p>
                </div>
            </div>
            
            <?php if($plans->count() > 0): ?>
                <div class="grid grid-cols-1 md:grid-cols-2 lg:grid-cols-3 gap-4">
                    <?php $__currentLoopData = $plans; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $plan): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                    <div class="group bg-gray-50 dark:bg-blue-600 rounded-lg p-4 hover:bg-gray-100 dark:hover:bg-blue-500 transition-all duration-300">
                        <div class="flex items-start justify-between mb-3">
                            <div class="flex-1">
                                <h4 class="font-medium text-black dark:text-white text-sm mb-1"><?php echo e($plan->name); ?></h4>
                                <p class="text-xs text-gray-600 dark:text-blue-100"><?php echo e($plan->category); ?></p>
                            </div>
                            <span class="inline-flex items-center px-2 py-0.5 rounded-full text-xs font-medium <?php echo e($plan->risk_level_badge); ?>">
                                <?php echo e(ucfirst($plan->risk_level)); ?>

                            </span>
                        </div>
                        
                        <div class="space-y-2 mb-3">
                            <div class="flex justify-between">
                                <span class="text-xs text-gray-500 dark:text-blue-200">NAV:</span>
                                <span class="text-xs font-medium text-black"><?php echo e(currency_symbol()); ?><?php echo e(number_format($plan->nav, 4)); ?></span>
                            </div>
                            <div class="flex justify-between">
                                <span class="text-xs text-gray-500 dark:text-blue-200">Return:</span>
                                <span class="text-xs font-medium <?php echo e($plan->nav_change_percentage >= 0 ? 'text-green-600' : 'text-red-600'); ?>">
                                    <?php echo e($plan->nav_change_percentage >= 0 ? '+' : ''); ?><?php echo e(number_format($plan->nav_change_percentage, 2)); ?>%
                                </span>
                            </div>
                            <div class="flex justify-between">
                                <span class="text-xs text-gray-500 dark:text-blue-200">Min:</span>
                                <span class="text-xs font-medium text-black"><?php echo e(currency_symbol()); ?><?php echo e(number_format($plan->minimum_investment, 0)); ?></span>
                            </div>
                        </div>
                        
                        <div class="flex items-center justify-between">
                            <a href="<?php echo e(route('investments.show', $plan)); ?>" class="text-xs text-blue-600 hover:text-blue-800 transition-colors duration-200">
                                View Details
                            </a>
                            <a href="<?php echo e(route('investments.buy', $plan)); ?>" class="px-2 py-1 bg-black dark:bg-white text-white dark:text-blue-900 text-xs font-medium rounded transition-colors duration-200 hover:bg-gray-800">
                                Invest
                            </a>
                        </div>
                    </div>
                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                </div>

                <!-- Pagination -->
                <div class="mt-6">
                    <?php echo e($plans->links()); ?>

                </div>
            <?php else: ?>
                <div class="text-center py-8">
                    <div class="w-12 h-12 bg-gray-100 dark:bg-blue-600 rounded-full flex items-center justify-center mx-auto mb-3">
                        <i data-lucide="trending-up" class="w-6 h-6 text-gray-400 dark:text-blue-200"></i>
                    </div>
                    <h3 class="text-base font-light text-black dark:text-white mb-1">No investment plans found</h3>
                    <p class="text-gray-600 text-xs mb-3">Try adjusting your filters or check back later</p>
                    <a href="<?php echo e(route('investments.index')); ?>" class="inline-flex items-center px-4 py-2 bg-black dark:bg-white text-white dark:text-blue-900 text-xs font-medium rounded-lg hover:bg-gray-800 dark:hover:bg-blue-50 transition-colors duration-200">
                        <i data-lucide="refresh-cw" class="w-3 h-3 mr-1"></i>
                        Clear Filters
                    </a>
                </div>
            <?php endif; ?>
        </div>
    </div>

    <script>
        function toggleFilters() {
            const filterSection = document.getElementById('filterSection');
            const filterIcon = document.getElementById('filterIcon');
            
            if (filterSection.classList.contains('hidden')) {
                filterSection.classList.remove('hidden');
                filterIcon.style.transform = 'rotate(180deg)';
            } else {
                filterSection.classList.add('hidden');
                filterIcon.style.transform = 'rotate(0deg)';
            }
        }
    </script>
 <?php echo $__env->renderComponent(); ?>
<?php endif; ?>
<?php if (isset($__attributesOriginal951024bfcf58033c82ac11d797616473)): ?>
<?php $attributes = $__attributesOriginal951024bfcf58033c82ac11d797616473; ?>
<?php unset($__attributesOriginal951024bfcf58033c82ac11d797616473); ?>
<?php endif; ?>
<?php if (isset($__componentOriginal951024bfcf58033c82ac11d797616473)): ?>
<?php $component = $__componentOriginal951024bfcf58033c82ac11d797616473; ?>
<?php unset($__componentOriginal951024bfcf58033c82ac11d797616473); ?>
<?php endif; ?> 
<?php /**PATH /home/hyipcode/my.hyipcoders.info/resources/views/investments/index.blade.php ENDPATH**/ ?>